% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{subsample_scExp}
\alias{subsample_scExp}
\title{Subsample scExp}
\usage{
subsample_scExp(scExp, n_cell_per_sample = 500, n_cell_total = NULL)
}
\arguments{
\item{scExp}{A SingleCellExperiment}

\item{n_cell_per_sample}{An integer number of cells to subsample for each sample.
Exclusive with n_cells_total. (500)}

\item{n_cell_total}{An integer number of cells to subsample in total. Exclusive
with n_cell_per_sample (NULL).}
}
\value{
A subsampled SingleCellExperiment
}
\description{
Randomly sample x cells from each sample in a SingleCellExperiment to return
a subsampled SingleCellExperiment with all samples having maximum n cells. If
n is higher than the number of cell in a sample, this sample will not be
subsampled.
}
\examples{
raw <- create_scDataset_raw()
scExp = create_scExp(raw$mat, raw$annot)
scExp_sub = subsample_scExp(scExp,50)
\dontrun{num_cell_scExp(scExp_sub)}

}
