% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{reduce_dims_scExp}
\alias{reduce_dims_scExp}
\title{Reduce dimensions (PCA, TSNE, UMAP)}
\usage{
reduce_dims_scExp(
  scExp,
  dimension_reductions = c("PCA", "UMAP"),
  n = 10,
  batch_correction = FALSE,
  batch_list = NULL,
  remove_PC = NULL,
  verbose = TRUE
)
}
\arguments{
\item{scExp}{A SingleCellExperiment object.}

\item{dimension_reductions}{A character vector of methods to apply.
(c('PCA','TSNE','UMAP'))}

\item{n}{Numbers of dimensions to keep for PCA. (50)}

\item{batch_correction}{Do batch correction ? (FALSE)}

\item{batch_list}{List of characters. Names are batch names, characters are
sample names.}

\item{remove_PC}{A vector of string indicating which principal components to
remove before downstream analysis as probably correlated to
library size. Should be under the form : 'Component_1', 'Component_2', ...
Recommended when using 'TFIDF' normalization method. (NULL)}

\item{verbose}{Print messages ?(TRUE)}
}
\value{
A SingleCellExperiment object containing feature spaces. See
?reduceDims().
}
\description{
Reduce dimensions (PCA, TSNE, UMAP)
}
\examples{

raw <- create_scDataset_raw()
scExp = create_scExp(raw$mat, raw$annot)
scExp =  normalize_scExp(scExp, "CPM")
scExp = reduce_dims_scExp(scExp,dimension_reductions=c("PCA","UMAP"))

}
