% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_analysis.R
\name{preprocessing_filtering_and_reduction}
\alias{preprocessing_filtering_and_reduction}
\title{Preprocess and filter matrix annotation data project folder to SCE}
\usage{
preprocessing_filtering_and_reduction(
  datamatrix,
  annot_raw,
  min_reads_per_cell = 1600,
  max_quantile_read_per_cell = 95,
  n_top_features = 40000,
  norm_type = "CPM",
  n_dims = 10,
  remove_PC = NULL,
  subsample_n = NULL,
  ref_genome = "hg38",
  exclude_regions = NULL,
  doBatchCorr = FALSE,
  batch_sels = NULL
)
}
\arguments{
\item{datamatrix}{A sparse count matrix of features x cells.}

\item{annot_raw}{A data.frame with barcode, cell_id, sample_id, batch_id, total_counts}

\item{min_reads_per_cell}{Minimum read per cell to keep the cell}

\item{max_quantile_read_per_cell}{Upper count quantile threshold above which cells are removed}

\item{n_top_features}{Number of features to keep}

\item{norm_type}{Normalization type c("CPM", "TFIDF", "RPKM", "TPM", "feature_size_only")}

\item{n_dims}{An integer specifying the number of dimensions to keep for PCA}

\item{remove_PC}{A vector of string indicating which principal components to
remove before downstream analysis as probably correlated to
library size. Should be under the form : 'Component_1', 'Component_2', ...
Recommended when using 'TFIDF' normalization method. (NULL)}

\item{subsample_n}{Number of cells to subsample.}

\item{ref_genome}{Reference genome ("hg38" or "mm10").}

\item{exclude_regions}{GenomicRanges with regions to remove from the object.}

\item{doBatchCorr}{Run batch correction ? TRUE or FALSE}

\item{batch_sels}{If doBatchCorr is TRUE, List of characters.
Names are batch names, characters are sample names.}
}
\value{
A SingleCellExperiment object containing feature spaces.
}
\description{
Preprocess and filter matrix annotation data project folder to SCE
}
\examples{
raw <- create_scDataset_raw()
scExp = preprocessing_filtering_and_reduction(raw$mat, raw$annot)
}
