% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_analysis_gene_set_enrichment.R
\name{combine_enrichmentTests}
\alias{combine_enrichmentTests}
\title{Run enrichment tests and combine into list}
\usage{
combine_enrichmentTests(
  diff,
  enrichment_qval,
  qval.th,
  logFC.th,
  min.percent,
  annotFeat_long,
  peak_distance,
  refined_annotation,
  GeneSets,
  GeneSetsDf,
  GenePool,
  progress = NULL
)
}
\arguments{
\item{diff}{Differential list}

\item{enrichment_qval}{Adusted p-value threshold above which a pathway is
considered significative list}

\item{qval.th}{Differential analysis adjusted p.value threshold}

\item{logFC.th}{Differential analysis log-fold change threshold}

\item{min.percent}{Minimum fraction of cells having the feature active to
consider it as significantly differential. (0.01)}

\item{annotFeat_long}{Long annotation}

\item{peak_distance}{Maximum gene to peak distance}

\item{refined_annotation}{Refined annotation data.frame if peak calling is
done}

\item{GeneSets}{List of pathways}

\item{GeneSetsDf}{Data.frame of pathways}

\item{GenePool}{Pool of possible genes for testing}

\item{progress}{A shiny Progress instance to display progress bar.}
}
\value{
A list of list of pathway enrichment data.frames for
Both / Over / Under and for each cluster
}
\description{
Run enrichment tests and combine into list
}
