% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_summaryStats.R
\name{calculateParamDist}
\alias{calculateParamDist}
\title{calculateParamDist
 
\code{calculateParamDist} calculates the quality parameters of one iteration.
This function samples \code{nregions} rows from the stat matrix and fits 
the linear model \code{lm(d ~ 0 + u + w)}}
\usage{
calculateParamDist(i, stats, nregions)
}
\arguments{
\item{i}{a numeric value indicating the current iteration.}

\item{stats}{a \code{data.table} object with the response and covariates for
the model}

\item{nregions}{a numeric value indicating the number of regions sampled.}
}
\value{
a \code{data.table} with both parameters and some extra info
}
\description{
calculateParamDist
 
\code{calculateParamDist} calculates the quality parameters of one iteration.
This function samples \code{nregions} rows from the stat matrix and fits 
the linear model \code{lm(d ~ 0 + u + w)}
}
\examples{
data("exoExample")
DT <- formatRegions(exoExample)
calculateParamDist(1,DT,100)

}
