% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mca.R
\name{setDimMCSlot}
\alias{setDimMCSlot}
\alias{setDimMCSlot.Seurat}
\alias{setDimMCSlot.SingleCellExperiment}
\title{SetDimSlot}
\usage{
setDimMCSlot(X, cellEmb, geneEmb, stdev, reduction.name, ...)

\method{setDimMCSlot}{Seurat}(
  X,
  cellEmb,
  geneEmb,
  stdev = NULL,
  reduction.name = "mca",
  assay = DefaultAssay(X),
  ...
)

\method{setDimMCSlot}{SingleCellExperiment}(X, cellEmb, geneEmb, stdev = NULL, reduction.name = "MCA", ...)
}
\arguments{
\item{X}{Seurat or SingleCellExperiment object}

\item{cellEmb}{cell coordinates returned by MCA}

\item{geneEmb}{feature coordinates returned by MCA}

\item{stdev}{eigen value returned by MCA}

\item{reduction.name}{name of the created dimensionlaity reduction, default set to 'mca' for Seurat and 'MCA' for SCE.}

\item{...}{other arguments passed to methods}

\item{assay}{Seurat assay slot}
}
\value{
Seurat or SingleCellExperiment object with MC stored in the reduction slot
}
\description{
Integrate MCA in Seurat and SingleCellExperiment Dimensionlity reduction Slot.
It will set also a small parameter inside the dimensionality reduction object to signal if it is a MCA or not.
}
