% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyper.R
\name{RunCellHGT}
\alias{RunCellHGT}
\alias{RunCellHGT.SingleCellExperiment}
\alias{RunCellHGT.Seurat}
\title{Run HyperGeometric Test on cells}
\usage{
RunCellHGT(
  X,
  pathways,
  reduction,
  n.features,
  features,
  dims,
  minSize,
  log.trans,
  p.adjust
)

\method{RunCellHGT}{SingleCellExperiment}(
  X,
  pathways,
  reduction = "MCA",
  n.features = 200,
  features = NULL,
  dims = seq(50),
  minSize = 10,
  log.trans = TRUE,
  p.adjust = TRUE
)

\method{RunCellHGT}{Seurat}(
  X,
  pathways,
  reduction = "mca",
  n.features = 200,
  features = NULL,
  dims = seq(50),
  minSize = 10,
  log.trans = TRUE,
  p.adjust = TRUE
)
}
\arguments{
\item{X}{Seurat or SingleCellExperiment object with mca performed}

\item{pathways}{geneset to perform hypergeometric test on (named list of genes)}

\item{reduction}{name of the MCA reduction}

\item{n.features}{integer of top n features to consider for hypergeometric test}

\item{features}{vector of features to calculate the gene ranking by default will take everything in the selected mca reduction.}

\item{dims}{MCA dimensions to use to compute n.features top genes.}

\item{minSize}{minimum number of overlapping genes in geneset and}

\item{log.trans}{if TRUE tranform the pvalue matrix with -log10 and convert it to sparse matrix}

\item{p.adjust}{if TRUE apply Benjamini Hochberg correction to p-value}
}
\value{
a matrix of benjamini hochberg adjusted pvalue pvalue or a sparse matrix of (-log10) benjamini hochberg adjusted pvalue
}
\description{
RunCellHGT calculates the gene signatures for each cells and performs hypergeometric 
test against a user defined gene signatures/pathways (named list of genes).
It returns a score of enrichment in the form of -log10 pvalue(see log.trans argument). 
The obtained matrix can then be integrated in Seurat or SingleCellExperiment object.
It can notably be used with cell type signatures to predict cell types or with functionnal pathways
}
\examples{
seuratPbmc <- RunMCA(seuratPbmc, nmcs = 5)
Enrichment <- RunCellHGT(X = seuratPbmc, pathways = Hallmark, dims = 1:5)
}
