% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-methods.R
\name{.needsToBeExpanded}
\alias{.needsToBeExpanded}
\title{AUX Check if projection needs to be expanded}
\usage{
.needsToBeExpanded(g, cl)
}
\arguments{
\item{g}{Trajectory graph; \code{igraph} object}

\item{cl}{Trajectory states vector; logical}
}
\value{
A logical value
}
\description{
Simple graphs having only bifurcations along the backbone get
simplified by a 2D projection. If a fork with more than two successors
or a fork not located along the backbone, but along a side branch, the
2D simplification would collate the states and ignore the bifurcation.
Therefore, the simplification step has to be skipped. This methods
checks whether a siplification is possible or not.
}
\details{
IF: any node has a degree > 3, return \code{TRUE}; OTHERWISE:
Check all shortest paths from start node to any leaf in trajectory
tree. IF any path passes a node with degree > 3, which is not located
on the backbone, return \code{TRUE}; OTHERWISE: return \code{FALSE}.
}
\author{
Daniel C. Ellwanger
}
\keyword{internal}
