% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation-methods.R
\docType{methods}
\name{simulate_exprs}
\alias{simulate_exprs}
\title{Simulation of RNA-Seq expression data}
\usage{
simulate_exprs(n_features, n_samples, prefix_sample = "")
}
\arguments{
\item{n_features}{Number of genes}

\item{n_samples}{Number of samples}

\item{prefix_sample}{Prefix of sample name}
}
\value{
A numeric matrix with genes in rows and samples in columns
}
\description{
Simple simulation of RNA-Seq expression data estimating counts based
on the negative binomial distribution
}
\details{
RNA-Seq counts are generated using the Negative Binomial
Distribution. Distribution parameters for each feature are sampled
from a Gamma distribution. The resulting expression matrix is log2-scaled.
}
\examples{
# Matrix with 100 genes and 50 cells
dat <- simulate_exprs(n_features=100, n_samples=50)
}
\seealso{
\code{NegBinomial} and \code{GammaDist}
}
\author{
Daniel C. Ellwanger
}
