% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{pca}
\alias{pca}
\alias{pca,SingleCellExperiment-method}
\title{Principal Component Analysis}
\usage{
pca(sce, do_scaling = TRUE, design = NULL)
}
\arguments{
\item{sce}{\code{SingleCellExperiment} object}

\item{do_scaling}{FALSE = covariance matrix, TRUE = correlation matrix}

\item{design}{A numeric matrix describing the factors that should be blocked}
}
\value{
A \code{list} object containing the following components:
  \item{\code{components}}{Principal components}
  \item{\code{eigenvalues}}{Variance per component}
  \item{\code{variance}}{Fraction of variance explained by each component}
  \item{\code{loadings}}{Loading score for each feature}
}
\description{
Performs principal component analysis by spectral decomposition of
a covariance or correlation matrix
}
\details{
The calculation is done by a spectral decomposition of the
(scaled) covariance matrix of the trajectory features
as defined in the \code{SingleCellExperiment} object.
Features with zero variance get automatically removed.
Please note that this methods only uses the set of defined trajectory
features in a \code{SingleCellExperiment} object; spike-in controls are
ignored and are not listed as trajectory features.
\cr \cr
To account for systematic bias in the expression data
(e.g., cell cycle effects), a
design matrix can be provided for the learning process. It should list
the factors that should be blocked and
their values per sample. It is suggested to construct a design matrix with
\code{model.matrix}.
}
\examples{
# Example data
data(exSCE)

# Principal component analysis
res <- pca(exSCE)

# Find relevant number of principal components
d <- findSpectrum(res$eigenvalues, frac=20)

barplot(res$variance[d] * 100, ylab="Variance (\%)",
        names.arg=colnames(res$components)[d], las=2)
plot(res$component, xlab="PC1", ylab="PC2")
}
\seealso{
\code{SingleCellExperiment} \code{model.matrix}
}
\author{
Daniel C. Ellwanger
}
