% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldfHelper.R
\name{.defineSubspace}
\alias{.defineSubspace}
\title{.defineSubspace}
\usage{
.defineSubspace(sce, assay_name, dim_red, n_dim)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object with the data to define the
subspace.}

\item{assay_name}{Character. Name of the assay to use for PCA. Only relevant
if no existing 'dim_red' is provided. Must be one of
\code{names(assays(sce))}.}

\item{dim_red}{Character. Name of embeddings to use as subspace.}

\item{n_dim}{Numeric. Number of subspace elements to include to define
subspace.}
}
\value{
A matrix of cell embeddings with reduced dimensions as columns.
}
\description{
Helper function for ldfSce and cms to define or recalculate the subspace for
analysis.
}
\details{
Function to determine the subspace for \code{ldfDiff} and
\code{cms}. Checks whether the defined 'dim_red' is present.
Only if no subspace is defined or present it will perform a PCA using
\code{runPCA}. To calculate PCA counts defined in 'assay_name' are used.
}
\seealso{
\code{\link{ldfSce}}, \code{\link{cms}}.

Other helper functions: 
\code{\link{.cmsCell}()},
\code{\link{.filterKnn}()},
\code{\link{.filterLocMin}()},
\code{\link{.ldfKnn}()},
\code{\link{.smoothCms}()}
}
\concept{helper functions}
