% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-plot_barcode.R
\name{bc_plot_pair}
\alias{bc_plot_pair}
\alias{bc_plot_pair,BarcodeObj-method}
\title{Barcode read count 2D scatter plot for given pairs}
\usage{
bc_plot_pair(
  barcodeObj,
  sample_x,
  sample_y,
  count_marks_x = NULL,
  count_marks_y = NULL,
  highlight = NULL,
  log_coord = TRUE,
  alpha = 0.7
)

\S4method{bc_plot_pair}{BarcodeObj}(
  barcodeObj,
  sample_x,
  sample_y,
  count_marks_x = NULL,
  count_marks_y = count_marks_x,
  highlight = NULL,
  log_coord = TRUE,
  alpha = 0.7
)
}
\arguments{
\item{barcodeObj}{A \code{BarcodeObj} object.}

\item{sample_x}{A character vector or a integer vector, specifying the sample
in \code{x} axis of each scatter plot. It can be the sample names in
BarcodeObj or the sample index value.}

\item{sample_y}{A character vector or a integer vector, similar to
\code{sample_x}, specifying the samples used for \code{y} axis. It can be the
sample names or the
sample index value.}

\item{count_marks_x}{A numeric vector used to mark the cutoff
point for samples in x
axis}

\item{count_marks_y}{A number vector used to mark the cutoff point for
samples in the y-axis.}

\item{highlight}{A character vector, specifying the barcodes that need to be
highlighted.}

\item{log_coord}{A logical value, if TRUE (default), the \code{x} and
\code{y} coordinates
of the scatter will be transformed by log10.}

\item{alpha}{A numeric between 0 and 1, specifies the transparency of the
dots in the scatter plot.}
}
\value{
Scatter plot matrix.
}
\description{
Draws scatter plot for barcode read count between given pairs of samples with
a \code{BarcodeObj} object. This function will return a scatter plot matrix
contains the scatter plots for all given sample pairs.
}
\examples{

data(bc_obj)

bc_names(bc_obj)

bc_plot_pair(barcodeObj=bc_obj, sample_x="test1", sample_y="test2",
    count_marks_x=30, count_marks_y=20)
###
}
