% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CellBarcode.R
\docType{data}
\name{bc_obj}
\alias{bc_obj}
\title{A dummy BarcodeObj object}
\format{
This is a BarcodeObj object
}
\source{
This is a \code{BarcodeObj} object derived from makeup data by:

\preformatted{
d1 = data.frame(
    seq = c(
       "ACTTCGATCGATCGAAAAGATCGATCGATC",
       "AATTCGATCGATCGAAGAGATCGATCGATC",
       "CCTTCGATCGATCGAAGAAGATCGATCGATC",
       "TTTTCGATCGATCGAAAAGATCGATCGATC",
       "AAATCGATCGATCGAAGAGATCGATCGATC",
       "CCCTCGATCGATCGAAGAAGATCGATCGATC",
       "GGGTCGATCGATCGAAAAGATCGATCGATC",
       "GGATCGATCGATCGAAGAGATCGATCGATC",
       "ACTTCGATCGATCGAACAAGATCGATCGATC",
       "GGTTCGATCGATCGACGAGATCGATCGATC",
       "GCGTCCATCGATCGAAGAAGATCGATCGATC"
       ),
    freq = c(
        30, 60, 9, 10, 14, 5, 10, 30, 6, 4 , 6
        )
    )

d2 = data.frame(
    seq = c(
       "ACTTCGATCGATCGAAACGATCGATCGATC",
       "AATTCGATCGATCGAAGAGATCGATCGATC",
       "TTTTCGATCGATCGAAAAGATCGATCGATC",
       "AAATCGATCGATCGAAGAGATCGATCGATC",
       "CCCTCGATCGATCGAAGAAGATCGATCGATC",
       "GGGTCGATCGATCGAAAAGATCGATCGATC",
       "GGATCGATCGATCGAAGAGATCGATCGATC",
       "ACTTCGATCGATCGAACAAGATCGATCGATC",
       "GGTTCGATCGATCGACGAGATCGATCGATC",
       "GCGTCCATCGATCGAAGAAGATCGATCGATC"
       ),
    freq = c(
        30, 9, 10, 14, 5, 10, 30, 6, 4 , 6
        )
    )

pattern = "TCGATCGATCGA([ACTG]+)ATCGATCGATC"
bc_obj = bc_extract(
    list(test1 = d1, test2 = d2), 
    pattern, sample_name=c("test1", "test2"))

bc_obj = bc_cure_depth(bc_obj, depth=5)

# Save the dummy data
# save(bc_obj, file = "./data/bc_obj.RData")
###
}
}
\usage{
data(bc_obj)
}
\value{
A \code{BarcodeObj} object.
}
\description{
Dataset contains a \code{BarcodeObj} with makeup barcode data.
}
\keyword{dataset}
