% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RIF.R
\name{RIF}
\alias{RIF}
\title{Regulatory Impact Factors (RIF) analysis}
\usage{
RIF(input, nta = NULL, ntf = NULL, nSamples1 = NULL, nSamples2 = NULL)
}
\arguments{
\item{input}{A matrix of expression with differentially expressed genes
and transcript factors in rows, and the samples in columns.}

\item{nta}{Number of Differentially Expressed (DE) genes.}

\item{ntf}{Number of Transcription Factors (TFs).}

\item{nSamples1}{Number of samples of condition 1.}

\item{nSamples2}{Number of samples of condition 2.}
}
\value{
Returns an dataframe with the regulatory impact factors metric for
each transcript factor.
}
\description{
The RIF algorithm identify critical transcript factors (TF) from
gene expression data.
}
\details{
The input matrix must have the rows and columns ordered by the following request:
\enumerate{
   \item \strong{rows}: DE genes followed by TFs;
   \item \strong{columns}: samples of condition1 followed by samples of condition2.
}
}
\examples{
# load RIF input example
data('RIF_input')

# performing RIF analysis
RIF_out <- RIF(input = RIF_input,
               nta = 104,
               ntf = 50,
               nSamples1 = 10,
               nSamples2 = 10)

}
\references{
REVERTER, Antonio et al. Regulatory impact factors: unraveling the
transcriptional regulation of complex traits from expression data.
Bioinformatics, v. 26, n. 7, p. 896-904, 2010.
\url{https://academic.oup.com/bioinformatics/article/26/7/896/212064}
}
