% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CeTF-class.R
\name{OutputData}
\alias{OutputData}
\alias{OutputData,CeTF-method}
\title{Output data accessor for a CeTF class object.}
\usage{
OutputData(x, analysis = "rif", type = "tab")

\S4method{OutputData}{CeTF}(x, analysis = "rif", type = "tab")
}
\arguments{
\item{x}{\code{\link{CeTF-class}} object}

\item{analysis}{Type of analysis: rif, pcit1, pcit2. The numbers 1 and 2 
correspond to the respective condition (default: rif).}

\item{type}{Type of matrix for PCIT output: tab, adj_raw or adj_sig 
(default: tab).}
}
\value{
Returns the Outputs used for RIF and PCIT.
}
\description{
The output accessor access the output matrices and lists 
used for RIF and PCIT analysis to both conditions resulted from 
\code{\link{runAnalysis}} function analysis.
}
\examples{
# load the CeTF class object resulted from runAnalysis function
data(CeTFdemo)

OutputData(CeTFdemo)

}
\seealso{
\code{\link{runAnalysis}}.
}
