% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WriteAllExplainedNodesToSifFile.r
\name{WriteAllExplainedNodesToSifFile}
\alias{WriteAllExplainedNodesToSifFile}
\title{Write all explained nodes to Sif file}
\usage{
WriteAllExplainedNodesToSifFile(scanResults, network, experimentalData, delta,
  correctlyExplainedOnly = TRUE, quiet = TRUE)
}
\arguments{
\item{scanResults}{a results object produced by ScanR}

\item{network}{a computational causal graph}

\item{experimentalData}{The experimental data read in using \link{ReadExperimentalData}.}

\item{delta}{the number of edges across which the hypothesis should be followed, the setting should be that used to generate the input ScanR object.}

\item{correctlyExplainedOnly}{if TRUE network files will only be produced for correctly explained nodes. If FALSE network files will be produced for each of correctly explained, incorrectly explained and ambiguously explained nodes.}

\item{quiet}{a flag to suppress output to console. FALSE by default.}
}
\value{
files containing paths from hypothesis node to explained nodes in sif format and corresponding annotation (_anno.txt) files
}
\description{
Outputs networks of all explained nodes in .sif file format, named by node name with sign of regulation, each with a corresponding annotation file for producing visualisations using Cytoscape.
}
\examples{
networkFile <- system.file(package='CausalR', 'extdata', 'testNetwork1.sif')
network <- CreateCCG(networkFile)
experimentalDataFile <- system.file(package='CausalR', 'extdata', 'testData1.txt')
experimentalData <- ReadExperimentalData(experimentalDataFile, network)
delta <- 2
scanResults <- runSCANR(network, experimentalData, numberOfDeltaToScan = delta,
    topNumGenes = 2, writeResultFiles = FALSE, writeNetworkFiles = "none",
    quiet = FALSE, doParallel = TRUE, numCores = 2)
WriteAllExplainedNodesToSifFile(scanResults, network, experimentalData, delta,
    correctlyExplainedOnly = TRUE, quiet = TRUE)
}
\concept{
CausalR
}

