% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankTheHypotheses.r
\name{RankTheHypotheses}
\alias{RankTheHypotheses}
\title{rank the hypotheses}
\usage{
RankTheHypotheses(network, experimentalData, delta, epsilon = 1e-05,
  useCubicAlgorithm = TRUE, use1bAlgorithm = TRUE, symmetricCCG = TRUE,
  listOfNodes = NULL, correctPredictionsThreshold = -Inf, quiet = FALSE,
  doParallel = FALSE, numCores = NULL, writeFile = TRUE,
  outputDir = getwd())
}
\arguments{
\item{network}{Computational Causal Graph, as an igraph.}

\item{experimentalData}{The experimental data read in using \link{ReadExperimentalData}. The results is an n x 2 matrix; where the first column contains the node ids of the nodes in the network that the results refer to. The second column contains values indicating the direction of regulation in the results - (+)1 for up, -1 for down and 0 for insignificant amounts of regulation. The name of the first column is the filename the data was read from.}

\item{delta}{Distance to search within the causal graph.}

\item{epsilon}{The threshold that is used when calculating the p-value using the cubic algorithm (see 'Assessing statistical significance in causal graphs').}

\item{useCubicAlgorithm}{An indicator specifying which algorithm will be used to calculate the p-value. The default is set as useCubicAlgorithm = TRUE which uses the cubic algorithm. If this value is set as FALSE, the algorithm will use the much slower quartic algorithm which does compute the exact answer, as opposed to using approximations like the cubic algorithm.}

\item{use1bAlgorithm}{An indicator specifying whether the 1a or 1b (default, faster) variant of the cubic algorithm described in Chindelevitch's paper will be used to calculate the p-value.}

\item{symmetricCCG}{This flag specifies whether the CCG is assumed to be symmetric. The value is set as TRUE as a default. If this is the case the running time of the algorithm is reduced since the bottom half of the table can be filled in using the results of calculations performed earlier.}

\item{listOfNodes}{A list of nodes specified by the user. The algorithm will only calculate and store the results for the nodes in the specified list. The default value is NULL; here the algorithm will calculate and store results for all the nodes in the network.}

\item{correctPredictionsThreshold}{A threshold on the number of correct predictions for a given hypothesis. If a hypothesis produces fewer correct predictions than predictionsThreshold then the algorithm will not calculate the two p-values. Instead 'NA' will be displayed in the final two columns of the corresponding row of the results table. As a default correctPredictionsThreshold is set as -Inf, so that the p-values are calculated for all specified hypotheses.}

\item{quiet}{a flag to suppress output to console. FALSE by default.}

\item{doParallel}{A flag for running RankTheHypothesis in parallel mode.}

\item{numCores}{Number of cores to use if using parallel mode. If the default value of NULL is used, it will attempt to detect the number of cores available and use all of them bar one.}

\item{writeFile}{A flag for determining if the output should be written to a file in the working directory. Default is TRUE.}

\item{outputDir}{the directory to output the files to. Default is the working directory}
}
\value{
A data frame containing the results of the algorithm.
}
\description{
Rank the hypotheses in the causal network. This function can be run with parallelisation using the doParallel flag.
}
\examples{
#get path to example network file
networkFile <- system.file(package='CausalR', 'extdata', 'testNetwork.sif')
#create ccg
network <- CreateCCG(networkFile)
#get path to example experimental data
experimentalDataFile <- system.file(package='CausalR', 'extdata', 'testData.txt')
#read in experimetal data
experimentalData <- ReadExperimentalData(experimentalDataFile, network)
#run in single threaded mode
RankTheHypotheses(network, experimentalData, 2)
#run in parallel mode
RankTheHypotheses(network, experimentalData, 2, doParallel=TRUE, numCores=2)
}
\references{
L Chindelevitch et al.
Assessing statistical significance in causal graphs.
BMC Bioinformatics, 13(35), 2012.
}
\concept{
CausalR
}

