% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculateSignificance.r
\name{CalculateSignificance}
\alias{CalculateSignificance}
\title{calculate overall significance p-value}
\usage{
CalculateSignificance(hypothesisScore, predictionListStats,
  experimentalResultStats, epsilon = 1e-05, useCubicAlgorithm = TRUE,
  use1bAlgorithm = TRUE)
}
\arguments{
\item{hypothesisScore}{score for a particular hypothesis}

\item{predictionListStats}{numbers of predicted up-regulated, 
predicted down-regulated and ambiguous predictions predicted by the algorithm}

\item{experimentalResultStats}{numbers of up-regulated, 
down-regulated and not significantly changed transcripts in the 
experimental data}

\item{epsilon}{threshold that is used when calculating the p-value 
using the cubic algorithm}

\item{useCubicAlgorithm}{use the cubic algorithm, defaults to TRUE}

\item{use1bAlgorithm}{use the 1b version of the algorithm, defaults to TRUE
used to calculate the p-value}
}
\value{
the resulting  p-value
}
\description{
Calculates the p-value of a score given the hypothesis score and the 
distribution table, using either the quartic or the (faster) cubic algorithm
}
\examples{
CalculateSignificance(5, c(7,4,19), c(6,6,18))
CalculateSignificance(5, c(7,4,19), c(6,6,18), useCubicAlgorithm=TRUE)
CalculateSignificanceUsingQuarticAlgorithm(5, c(7,4,19), c(6,6,18))
CalculateSignificance(5, c(7,4,19), c(6,6,18), useCubicAlgorithm=FALSE)
CalculateSignificance(5, c(7,4,19), c(6,6,18), 1e-5)
CalculateSignificance(5, c(7,4,19), c(6,6,18), epsilon=1e-5, useCubicAlgorithm=TRUE)
CalculateSignificanceUsingCubicAlgorithm(5, c(7,4,19), c(6,6,18), 1e-5)
}
\concept{
CausalR
}

