% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGenesVsCells.R
\name{sankeyFromMatrix}
\alias{sankeyFromMatrix}
\title{This makes a sankey graph from a matrix of average
expression.  Our "Cat's Cradle".}
\usage{
sankeyFromMatrix(
  M,
  disambiguation = c("R_", "C_"),
  fontSize = 20,
  minus = "red",
  plus = "blue",
  height = 1200,
  width = 900
)
}
\arguments{
\item{M}{\itemize{
\item a matrix of gene expression
}}

\item{disambiguation}{\itemize{
\item used to distinguish between
the row names and the column names if these overlap
}}

\item{fontSize}{\itemize{
\item defaults to 20
}}

\item{minus}{\itemize{
\item colour to use for links with negative
values
}}

\item{plus}{\itemize{
\item colour for positive values
}}

\item{height}{\itemize{
\item height in pixels, defaults to 1200
}}

\item{width}{\itemize{
\item width in pixels, defaults to 900
}}
}
\value{
A sankey graph
}
\description{
This makes a sankey graph from a matrix of average
expression.  Our "Cat's Cradle".
}
\examples{
set.seed(100)
M = matrix(runif(12)-.3,nrow=3)
rownames(M) = as.character(seq_len(3))
colnames(M) = as.character(seq_len(4))
sankey = sankeyFromMatrix(M)
}
