% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeneAnnotation.R
\name{orderGeneSetPValues}
\alias{orderGeneSetPValues}
\title{This orders the gene set p-values (or -log10 p-values) and
applies a cutoff (if given) to show only the significant
gene sets for each gene cluster}
\usage{
orderGeneSetPValues(M, ascending = TRUE, cutoff = NULL, nameTag = "")
}
\arguments{
\item{M}{\itemize{
\item A matrix of gene set p-values (or their logs)
to be ordered by their significance
}}

\item{ascending}{\itemize{
\item Direction in which to order the columns.
Defaults to TRUE, so that p-values will be ordered according
to decreasing significance, should be set to FALSE if ordering
-log p-value
}}

\item{cutoff}{\itemize{
\item if non-null this is used to extract only
significant cases
}}

\item{nameTag}{\itemize{
\item can be used to modify the names of the list.
}}
}
\value{
This returns a list of whose entries are data frames,
one for each gene cluster, each giving the significant gene sets
for that cluster and their significance.
}
\description{
This orders the gene set p-values (or -log10 p-values) and
applies a cutoff (if given) to show only the significant
gene sets for each gene cluster
}
