% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleNeighbourhoodAnalysis.R
\name{cellTypesPerCellTypeGraphFromCellMatrix}
\alias{cellTypesPerCellTypeGraphFromCellMatrix}
\title{This function converts a matrix as found by
cellTypesPerCellTypeMatrix into a directed igraph
whose vertices correspond to seurat_clusters and whose
edge correspond to occupancy fraction.}
\usage{
cellTypesPerCellTypeGraphFromCellMatrix(
  M,
  colours = NULL,
  selfEdges = FALSE,
  minWeight = 0,
  edgeWeighting = 20,
  edgeCurved = 0.2,
  arrowSize = 4,
  arrowWidth = 4,
  plotGraph = TRUE
)
}
\arguments{
\item{M}{\itemize{
\item a matrix as found by cellTypesPerCellTypeMatrix. Note,
however, that this matrix may need to be reduced to a square matrix
as the matrix produced from a subset object may be missing certain
cell types as rows.
}}

\item{colours}{\itemize{
\item a named vector of colours used to colour the
vertices of the graph.  The names are the seurat_clusters
as character strings.
}}

\item{selfEdges}{\itemize{
\item a logical which determines whether to include
self edges.  Defaults to FALSE
}}

\item{minWeight}{\itemize{
\item Allows one to exclude edges of low weight.
Defaults to 0, thus including all edges.
}}

\item{edgeWeighting}{\itemize{
\item a parameter used to thicken the edges
in the display.  Defaults to 20.
}}

\item{edgeCurved}{\itemize{
\item a parameter to set curvature of the edges.
Defaults to 0.2
}}

\item{arrowSize}{\itemize{
\item a parameter to set arrow size. Defaults to 4.
}}

\item{arrowWidth}{\itemize{
\item a parameter to set arrow width. Defaults to 4.
}}

\item{plotGraph}{\itemize{
\item a logical which determines whether to
plot the graph.  Defaults to TRUE.
}}
}
\value{
This returns a directed igraph whose vertices are
the cell types and whose arrows indicate "ownership" of
cells of the target type by neighbourhoods of cells of the
source type.  Layout is done witht the FR algorithm and
coordinates are found in the coords attribute of G.  If colours
were supplied these are found in color attribute of V(G).  Edge
weights and widths are found in the weight and width attributes
of E(G).
}
\description{
This function converts a matrix as found by
cellTypesPerCellTypeMatrix into a directed igraph
whose vertices correspond to seurat_clusters and whose
edge correspond to occupancy fraction.
}
\examples{
getExample = make.getExample()
cellTypesPerCellTypeMatrix = getExample('cellTypesPerCellTypeMatrix')
colours = getExample('colours')
G = cellTypesPerCellTypeGraphFromCellMatrix(cellTypesPerCellTypeMatrix, 
                                   minWeight = 0.05, colours = colours)
}
