% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_plotting.R
\name{plotCalibraCurve}
\alias{plotCalibraCurve}
\title{Plot the calibration curve}
\usage{
plotCalibraCurve(
  CC_RES,
  ylab = "Intensity",
  xlab = "Concentration",
  show_regression_info = FALSE,
  show_linear_range = TRUE,
  show_data_points = TRUE,
  plot_type = "multiplot",
  point_colour = "black",
  curve_colour = "red",
  linear_range_colour = "black",
  multiplot_nrow = NULL,
  multiplot_ncol = NULL,
  multiplot_scales = "free"
)
}
\arguments{
\item{CC_RES}{\strong{list} \cr Results of \code{\link{CalibraCurve}}. Each list
element is the result of \code{\link{calc_single_curve}}}

\item{ylab}{\strong{character(1)} \cr y-axis label.}

\item{xlab}{\strong{character(1)} \cr x-axis label.}

\item{show_regression_info}{\strong{logical(1)} \cr If TRUE, show regression
information (R2, slope, intercept) on the plot.}

\item{show_linear_range}{\strong{logical(1)} \cr If TRUE, show the linear range
of the calibration curve as a rectangle in the plot.}

\item{show_data_points}{\strong{logical(1)} \cr If TRUE, show the data points on
the plot.}

\item{plot_type}{\strong{character(1)} \cr Type of plot for calibration curves:
"single_plots" (default, generate a separate plot for each substance),
"multiplot" (generate a graphic with subplots for each substance)
or "all_in_one" (generate a single plot with all substances).}

\item{point_colour}{\strong{character(1)} \cr Colour of the data points, default
is "black".}

\item{curve_colour}{\strong{character(1)} \cr Colour of the calibration curve,
default is "red".}

\item{linear_range_colour}{\strong{character(1)} \cr Colour of the linear range
background, default is "black" (colour is weakened by alpha = 0.1).}

\item{multiplot_nrow}{\strong{integer(1)} \cr Number of rows for the multiplot
layout (default is NULL, which means that there is only one row).}

\item{multiplot_ncol}{\strong{integer(1)} \cr Number of columns for the multiplot
layout (default is NULL, which means that the number of columns is
determined automatically based on the number of curves).}

\item{multiplot_scales}{\strong{character(1)} \cr Scales for the multiplot layout,
default is "free" (which means that each plot has its own scales). Other
options are "fixed", "free_x", "free_y".}
}
\value{
List of a ggplot2 object containing the calibration curve plot (CC_plot) and
a data.frame containing summary data for annotations (annotation_dat).
}
\description{
Plot the calibration curve
}
\examples{
file <- system.file("extdata", "MSQC1", "msqc1_dil_GGPFSDSYR.rds",
    package = "CalibraCurve"
)
D_list <- readDataSE(file,
    concColName = "amount_fmol",
    substColName = "Substance", assayNumber = 1
)
CC_RES <- calc_single_curve(D_list[[1]], calcContinuousPrelimRanges = FALSE)

plotCalibraCurve(list(substance = CC_RES))
}
