% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_writing_results.R
\name{assemble_results}
\alias{assemble_results}
\title{Assemble result tables}
\usage{
assemble_results(
  X,
  dataCleaned,
  PLR_res,
  resFacDataV,
  avgResFacDataV,
  FLR_res,
  mod,
  cvThres = 20,
  RfThresL = 80,
  RfThresU = 120,
  substance = "substance1"
)
}
\arguments{
\item{X}{\strong{data.frame} \cr Original data set, e.g. result of
\code{\link{readDataTable}}.}

\item{dataCleaned}{\strong{list of data.frames} \cr Cleaned data, result of
\code{\link{cleanData}}.}

\item{PLR_res}{\strong{list} \cr Result object of \code{\link{calculate_PLR}}.}

\item{resFacDataV}{\strong{list} \cr  List of response factor values for each
concentration level.}

\item{avgResFacDataV}{\strong{numeric} \cr Vector of mean response factor values
for the different concentration levels.}

\item{FLR_res}{\strong{list} Result object of \code{\link{calculate_FLR}}.}

\item{mod}{\strong{lm object} \cr Final linear model fit (object "mod" from
results of \code{\link{calculate_FLR}}).}

\item{cvThres}{\strong{numeric(1)} \cr Threshold for CV per concentration level
in percent (default is 20).}

\item{RfThresL}{\strong{numeric(1)} \cr Lower threshold for response factor in
percent (default is 80).}

\item{RfThresU}{\strong{numeric(1)} \cr Upper threshold for response factor in
percent (default is 120).}

\item{substance}{\strong{character(1)} \cr Name of the substance (default is
"substance1").}
}
\value{
List with the following elements:
\itemize{
\item \code{result_table_conc_levels}: Result table with one line for each
concentration level.
\item \code{result_table_obs}: Result table with one line per observation (e.g.
individual response factors for each data point).
}
}
\description{
Assemble result tables
}
\examples{
file <- system.file("extdata", "MSQC1", "msqc1_dil_GGPFSDSYR.rds",
package = "CalibraCurve")
D_list <- readDataSE(file, concColName = "amount_fmol",
        substColName = "Substance", assayNumber = 1)
data_cleaned <- cleanData(D_list[[1]])

RES_PLR <- calculate_PLR(data_cleaned, calcContinuousPrelimRanges = FALSE)
RES_FLR <- calculate_FLR(RES_PLR$dataPrelim)
RFs <- calcRF(data_cleaned, mod = RES_FLR$mod)

assemble_results(
    X = D_list[[1]],
    dataCleaned = data_cleaned,
    PLR_res = RES_PLR,
    resFacDataV = RFs$RFs,
    avgResFacDataV = RFs$meanRFs,
    FLR_res = RES_FLR,
    mod = RES_FLR$mod
)
}
