% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutFilterPON.R
\name{mutFilterPON}
\alias{mutFilterPON}
\title{mutFilterPON}
\usage{
mutFilterPON(maf, PONfile = NULL, PONformat = "vcf", verbose = TRUE)
}
\arguments{
\item{maf}{An MAF data frame, generated by \code{\link{vcfToMAF}} function.}

\item{PONfile}{Panel-of-Normals files, which can be either obtained through 
GATK (https://gatk.broadinstitute.org/hc/en-us/articles/360035890631-Panel-of-Normals-PON-)
or generated by users. Should have at least four columns: CHROM, POS, REF, ALT.
Defalut: NULL.}

\item{PONformat}{The format of PON file, either "vcf" or "txt". Default: "vcf"}

\item{verbose}{Whether to generate message/notification during the 
filtration process. Default: TRUE.}
}
\value{
An MAF data frame where some variants have P tag in CaTag column
for PON filtration.
}
\description{
Filter variants based on Panel of Normals
}
\examples{
maf <- vcfToMAF(system.file("extdata",
"WES_EA_T_1_mutect2.vep.vcf", package="CaMutQC"))
mafF <- mutFilterPON(maf, PONfile=system.file("extdata",
"PON_test.txt", package="CaMutQC"), PONformat="txt")
}
