% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toMesKit.R
\name{toMesKit}
\alias{toMesKit}
\title{toMeskit}
\usage{
toMesKit(
  maf,
  clinicalFile,
  ccfFile = NULL,
  nonSyn.vc = NULL,
  use.indel.ccf = FALSE,
  ccf.conf.level = 0.95
)
}
\arguments{
\item{maf}{An MAF data frame, generated by \code{\link{vcfToMAF}} function.}

\item{clinicalFile}{A clinical data file includes Tumor_Sample_Barcode, 
Tumor_ID, Patient_ID. Tumor_Sample_Label is optional.}

\item{ccfFile}{A CCF file of somatic mutations. Default NULL.}

\item{nonSyn.vc}{List of Variant classifications 
which are considered as non-silent. Default NULL.}

\item{use.indel.ccf}{Whether include indels in ccfFile. Default FALSE.}

\item{ccf.conf.level}{The confidence level of CCF to identify 
clonal or subclonal. Only works when "CCF_std" or "CCF_CI_high" 
is provided in ccfFile. Default 0.95.}
}
\value{
An maf object that can be recognized by MesKit.
}
\description{
Transform a CaMutQC maf object to a MesKit maf object.
}
\examples{
maf_CaMutQC <- vcfToMAF(system.file("extdata/Multi-caller/",
package="CaMutQC"), multiVCF=TRUE)
clin_file <- system.file("extdata", "clin.txt", package="CaMutQC")
maf_MesKit <- toMesKit(maf_CaMutQC, clinicalFile=clin_file)
}
