% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAC_induction.R
\name{DAC_induction}
\alias{DAC_induction}
\title{Gene expression in cells treated or not by a demethylating agent}
\usage{
DAC_induction(
  genes = NULL,
  multimapping = TRUE,
  include_CTP = FALSE,
  values_only = FALSE
)
}
\arguments{
\item{genes}{\code{character} naming the selected genes. The default
value, \code{NULL}, takes all CT specific genes.}

\item{multimapping}{\code{logical(1)} defining whether to use
multi-mapped gene expression dataset
\code{CTdata::DAC_treated_cells_multimapping} or
\code{DAC_treated_cells}. Default is \code{TRUE}.}

\item{include_CTP}{\code{logical(1)} If \code{TRUE}, CTP genes are included.
(\code{FALSE} by default).}

\item{values_only}{\code{logical(1)}. If \code{TRUE}, the function will return the
gene normalised logcounts in all samples instead of the
heatmap. Default is \code{FALSE}.}
}
\value{
A heatmap of selected genes in cells treated or not by a
demethylating agent. If \code{values_only} is \code{TRUE}, gene normalised
logcounts are returned instead.
}
\description{
Plots a heatmap of normalised gene counts
(log-transformed) in a selection of cells treated or not by
5-Aza-2'-Deoxycytidine (DAC), a demethylating agent.
}
\details{
RNAseq data from cells treated or not with 5-aza downloaded from
SRA.  (SRA references and information about cell lines and DAC
treatment are stored the colData of \code{DAC_treated_cells}).  Data was
processed using a standard RNAseq pipeline.
\href{https://ccb.jhu.edu/software/hisat2/index.shtml}{hisat2} was used
to align reads to grch38 genome.
\href{https://rdrr.io/bioc/Rsubread/man/featureCounts.html}{featurecounts}
was used to assign reads to genes. Note that -M parameter was used
or not to allow or not counting multi-mapping reads.
}
\examples{
DAC_induction(genes = c("MAGEA1", "MAGEA3", "MAGEA4", "MAGEA6", "CTAG1A"))
DAC_induction(genes = c("MAGEA1", "MAGEA3", "MAGEA4", "MAGEA6", "CTAG1A",
    multimapping = FALSE))
}
