% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CT_correlated_genes.R
\name{CT_correlated_genes}
\alias{CT_correlated_genes}
\title{Gene correlations in CCLE cancer cell lines}
\usage{
CT_correlated_genes(gene, corr_thr = 0.5, values_only = FALSE)
}
\arguments{
\item{gene}{CT gene selected}

\item{corr_thr}{\code{numeric(1)} with default 0.5. Genes with an
absolute correlation coefficient (Pearson) higher than this
threshold will be highlighted.}

\item{values_only}{\code{logical(1)}, \code{FALSE} by default. If \code{TRUE}, the
function will return the correlation coefficients with all
genes instead of the plot.}
}
\value{
A plot where each dots represent the correlation
coefficients (Pearson) between genes and the specified CT gene
(entered as input). Genes with a correlation coefficient above
threshold are colored in red if they are CT genes or in blue,
if not. If \code{values_only = TRUE}, all correlations coefficients are
returned instead.
}
\description{
A function that uses expression data from CCLE cell
lines and highlights genes correlated (or anti-correlated) with
specified CT gene.  Genes with a correlation coefficient above
threshold are colored in red if they are CT genes or in blue,
if not.
}
\examples{
\dontrun{
CT_correlated_genes(gene = "MAGEA3")
}
}
