% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hESC_mean_methylation.R
\name{hESC_mean_methylation}
\alias{hESC_mean_methylation}
\title{Promoter methylation of any gene in hESC}
\usage{
hESC_mean_methylation(
  genes = NULL,
  include_CTP = FALSE,
  values_only = FALSE,
  na.omit = TRUE
)
}
\arguments{
\item{genes}{\code{character} naming the selected genes. The default
value, \code{NULL}, takes all CT (specific) genes.}

\item{include_CTP}{\code{logical(1)} If \code{TRUE}, CTP genes are included.
(\code{FALSE} by default).}

\item{values_only}{\code{logical(1)}, \code{FALSE} by default. If \code{TRUE}, the
function will return the methylation values in all samples
instead of the heatmap.}

\item{na.omit}{\code{logical(1)} specifying if genes with missing
methylation values in some tissues should be removed (\code{TRUE} by
default). Note that no gene clustering will be done when
methylation values are missing.}
}
\value{
Heatmap of mean promoter methylation of any
gene in hESC. If \code{values_only = TRUE}, a SummarizedExperiment cobtaining
methylation values is returned instead.
}
\description{
Plots a heatmap of mean promoter methylation levels of
any genes in human embryonic cell lines. WGBS methylation data was
downloaded from Encode. Methylation levels in tissues correspond to
the mean methylation of CpGs located in range of 1000 pb upstream
and 200 pb downstream from gene TSS.
}
\examples{
\dontrun{
hESC_mean_methylation()
}
}
