% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hESC_expression.R
\name{hESC_expression}
\alias{hESC_expression}
\title{Gene expression in human embryonic stem cells}
\usage{
hESC_expression(
  genes = NULL,
  include_CTP = FALSE,
  units = c("TPM"),
  scale_lims = NULL,
  values_only = FALSE
)
}
\arguments{
\item{genes}{\code{character} naming the selected genes. The default
value, \code{NULL}, takes all CT (specific) genes.}

\item{include_CTP}{\code{logical(1)} If \code{TRUE}, CTP genes are included.
(\code{FALSE} by default).}

\item{units}{\code{character(1)} with expression values unit. Can be
\code{"TPM"} (default) or \code{"log_TPM"} (log(TPM + 1)).}

\item{scale_lims}{\verb{vector of length 2} setting the lower and upper limits
of the heatmap colorbar. By default, the lower limit is 0, and the upper
limit corresponds to the third quartile of the logcounts values.}

\item{values_only}{\code{logical(1)}. If \code{TRUE}, the function will return the
SingleCellExperiment instead of the heatmap. Default is \code{FALSE}.}
}
\value{
A heatmap of selected CT genes expression in single cells from human
embryonic stem cells. If \code{values_only = TRUE}, a SummarizedExperiment
is returned instead.
}
\description{
Plots a heatmap of genes expression in human embryonic stem cells,
using RNAseq data downloaded from Encode database.
}
\examples{
\dontrun{
hESC_expression(include_CTP = FALSE, units = "log_TPM",
                  values_only = FALSE)
}
}
