% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCGA_expression.R
\name{TCGA_expression}
\alias{TCGA_expression}
\title{Gene expression in TCGA tumors}
\usage{
TCGA_expression(
  tumor = "all",
  genes = NULL,
  include_CTP = FALSE,
  units = c("TPM", "log_TPM"),
  values_only = FALSE
)
}
\arguments{
\item{tumor}{\code{character} defining the TCGA tumor type. Can be one
of "SKCM", "LUAD", "LUSC", "COAD", "ESCA", "BRCA", "HNSC", or
"all" (default).}

\item{genes}{\code{character} naming the selected genes. The default
value, \code{NULL}, takes all CT (specific) genes.}

\item{include_CTP}{\code{logical(1)} If \code{TRUE}, CTP genes are included.
(\code{FALSE} by default).}

\item{units}{\code{character(1)} with expression values unit.  Can be
\code{"TPM"} (default) or \code{"log_TPM"} (log(TPM + 1)).}

\item{values_only}{\code{logical(1)}. If \code{TRUE}, the function will return the
expression values in all samples instead of the
heatmap. Default is \code{FALSE}.}
}
\value{
A heatmap of selected CT genes expression in TCGA samples.
If \code{values_only = TRUE}, TPM expression data is returned instead.
}
\description{
Plots a heatmap of genes expression in TCGA samples (peritumoral
and tumor samples when a specific tumor type is specified, or tumor
samples only when tumor option is set to "all")
}
\examples{
\dontrun{
TCGA_expression(
    tumor = "LUAD", genes = c("MAGEA1", "MAGEA3"),
    units = "log_TPM")
}
}
