% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_ctd.R
\name{download_ctd_dise}
\alias{download_ctd_dise}
\title{Function to download diseases available in CTDbase}
\usage{
download_ctd_dise(verbose = FALSE, ask = TRUE)
}
\arguments{
\item{verbose}{(default \code{FALSE}) If set to \code{TRUE} is shows relevant
information of each step.}

\item{ask}{(default \code{TRUE}) If \code{TRUE} it asks the the persistent
location must be used.}
}
\value{
Passed name into \code{filename} argument if it could be download
\code{1} otherwise.
}
\description{
This function download the "Disease vocabulary" file (\code{CTD_diseases.tsv.gz})
from \code{http://ctdbase.org/downloads}.
}
\details{
The field included in the file (\code{CTD_diseases.tsv.gz}) are:
\enumerate{
 \item DiseaseName
 \item DiseaseID (MeSH or OMIM identifier)
 \item Definition
 \item AltDiseaseIDs (alternative identifiers; '|'-delimited list)
 \item ParentIDs (identifiers of the parent terms; '|'-delimited list)
 \item TreeNumbers (identifiers of the disease's nodes; '|'-delimited list)
 \item ParentTreeNumbers (identifiers of the parent nodes; '|'-delimited list)
 \item Synonyms ('|'-delimited list)
 \item SlimMappings (MEDIC-Slim mappings; '|'-delimited list)
 }
}
\examples{
download_ctd_dise()
file.exists( "CTD_diseases.tsv.gz" )
}
