% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tval.R
\name{calculateTvalue}
\alias{calculateTvalue}
\title{Calculates modified T-statistics values for the given label and comparison}
\usage{
calculateTvalue(preprocessedData, label, comparison, numSamples)
}
\arguments{
\item{preprocessedData}{A 
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment-class}}
object from \code{\link{preprocessData}}.}

\item{label}{A vector containing the labels to use for the samples in 
preprocessedData.}

\item{comparison}{A vector containing the comparison to be made. Names here 
need to correspond to the sample groups in the sample file (Eg. c("G1",G2") 
means the comparison G1/G2).}

\item{numSamples}{Number of samples in the dataset.}
}
\value{
A vector that is the modified T-statistics for the comparison and 
labels given.
}
\description{
This calculates the modified T-statistics for the given comparison.
}
\seealso{
\code{\link{DBAnalyze}} which calls this function
}
