% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FC.R
\name{calculateFC}
\alias{calculateFC}
\title{Calculates Fold change values for the given label and comparison}
\usage{
calculateFC(preprocessedData, label, comparison, numSamples)
}
\arguments{
\item{preprocessedData}{A 
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment-class}}
object from \code{\link{preprocessData}}.}

\item{label}{A vector containing the labels to use for the samples in 
preprocessedData.}

\item{comparison}{A vector containing the comparison to be made. 
Names here need to correspond to the sample groups in the sample file 
(Eg. c("G1",G2") means the comparison G1/G2).}

\item{numSamples}{Number of samples in the dataset.}
}
\value{
A vector that is the Fold change for the comparison and labels given.
}
\description{
This calculates the Fold change for the given comparison.
}
\seealso{
\code{\link{DBAnalyze}} which calls this function
}
\keyword{internal}
