% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentile_sets.R
\name{percentileSets}
\alias{percentileSets}
\title{Generates cell expressing input genes at an input percentile}
\usage{
percentileSets(geneSetExp, percentile = 90)
}
\arguments{
\item{geneSetExp}{A gene expression non-sparse matrix with the rows
restricted to the genes for which cell sets will be computed.}

\item{percentile}{A positive number under 100.}
}
\value{
A named list of character vectors of length
equaling the number of input genes. Each vector stores the cells expressing
the gene at or above the input percentile.
}
\description{
This function constructs, for each gene in the expression matrix, a set of
cells expressing the gene at or above the input percentile.
}
\examples{
mat <- matrix(0, 1000, 500)
rownames(mat) <- paste0('G', seq(1000))
colnames(mat) <- paste0('C', seq(500))
mat[sample(length(mat), 70000)] <- sample(50, 70000, TRUE)
mat <- mat[paste0('G', sample(1000, 3)), ]
percentileSets(mat)

}
