% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeHits.R
\name{writeHits}
\alias{writeHits}
\title{Write the hits of sequence search from a sequence to a file}
\usage{
writeHits(
  gRNA = NULL,
  seqname = NULL,
  matches = NULL,
  strand = NULL,
  file = NULL,
  gRNA.size = 20L,
  PAM = "NGG",
  PAM.pattern = "N[A|G]G$",
  max.mismatch = 4L,
  chrom.len = NULL,
  append = FALSE,
  PAM.location = "3prime",
  PAM.size = 3L,
  allowed.mismatch.PAM = 1L,
  seqs = NULL,
  baseEditing = FALSE,
  targetBase = "C",
  editingWindow = 4:8
)
}
\arguments{
\item{gRNA}{DNAString object with gRNA sequence with PAM appended
immediately after,e.g., ACGTACGTACGTACTGACGTCGG with 20bp gRNA sequence plus
3bp PAM sequence CGG}

\item{seqname}{sequence name as character}

\item{matches}{XStringViews object storing matched chromosome locations}

\item{strand}{strand of the match, + for plus strand and - for minus strand}

\item{file}{file path where the hits is written to}

\item{gRNA.size}{gRNA size, default 20}

\item{PAM}{PAM as regular expression for appending to the gRNA, default NGG
for SpCas9, change to TTTN for cpf1.}

\item{PAM.pattern}{PAM as regular expression for filtering the hits, default
N[A|G]G$ for spCas9. For cpf1, ^TTTN since it is a 5 prime PAM sequence.}

\item{max.mismatch}{maximum mismatch allowed within the gRNA (excluding PAM
portion) for filtering the hits, default 4}

\item{chrom.len}{length of the matched chromosome}

\item{append}{TRUE if append to existing file, false if start a new file}

\item{PAM.location}{PAM location relative to gRNA. For example, spCas9 PAM
is located on the 3 prime while cpf1 PAM is located on the 5 prime}

\item{PAM.size}{Size of PAM, default 3}

\item{allowed.mismatch.PAM}{Maximum number of mismatches allowed in the
offtargets comparing to the PAM sequence. Default to 1 for NGG PAM}

\item{seqs}{DNAString object containing a DNA sequence.}

\item{baseEditing}{Indicate whether to design gRNAs for base editing.
Default to FALSE If TRUE, please set baseEditing = TRUE, targetBase and
editingWidow accordingly.}

\item{targetBase}{Applicable only when baseEditing is set to TRUE. It is
used to indicate the target base for base editing systems, default to C for
converting C to T in the CBE system. Please change it to A if you intend to
use the ABE system.}

\item{editingWindow}{Applicable only when baseEditing is set to TRUE. It is
used to indicate the effective editing window to consider for the offtargets
search only, default to 4 to 8 which is for the original CBE system. Please
change it accordingly if the system you use have a different editing window,
or you would like to include offtargets with the target base in a larger
editing window.}
}
\value{
results are saved in the file specified by file
}
\description{
write the hits of sequence search from a sequence instead of BSgenome to a
file, internal function used by searchHits
}
\examples{

 if(interactive())
 {
    gRNAPlusPAM <- DNAString("ACGTACGTACGTACTGACGTCGG")
    x <- DNAString("AAGCGCGATATGACGTACGTACGTACTGACGTCGG")
    chrom.len <- nchar(as.character(x))
    m <- matchPattern(gRNAPlusPAM, x)
    names(m) <- "testing"
    writeHits(gRNA = gRNAPlusPAM, seqname = "chr1", 
        matches = m, strand = "+", file = "exampleWriteHits.txt", 
        chrom.len = chrom.len, append = FALSE, seqs = x)
 }
}
\references{
http://bioconductor.org/packages/2.8/bioc/vignettes/BSgenome/inst/doc/
GenomeSearching.pdf
}
\seealso{
offTargetAnalysis
}
\author{
Lihua Julie Zhu
}
\keyword{misc}
