% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchHits.R
\name{searchHits}
\alias{searchHits}
\title{Search for off targets in a sequence as DNAString}
\usage{
searchHits(
  gRNAs,
  seqs,
  seqname,
  max.mismatch = 3,
  PAM.size = 3,
  gRNA.size = 20,
  PAM = "NGG",
  PAM.pattern = "NNN$",
  allowed.mismatch.PAM = 2,
  PAM.location = "3prime",
  outfile,
  baseEditing = FALSE,
  targetBase = "C",
  editingWindow = 4:8
)
}
\arguments{
\item{gRNAs}{DNAStringSet object containing a set of gRNAs. Please note the
sequences must contain PAM appended after gRNAs, e.g.,
ATCGAAATTCGAGCCAATCCCGG where ATCGAAATTCGAGCCAATCC is the gRNA and CGG is
the PAM}

\item{seqs}{DNAString object containing a DNA sequence.}

\item{seqname}{Specify the name of the sequence}

\item{max.mismatch}{Maximum mismatch allowed in off target search, default
3. Warning: will be considerably slower if it is set to greater than 3}

\item{PAM.size}{Size of PAM, default 3}

\item{gRNA.size}{Size of gRNA, default 20}

\item{PAM}{PAM as regular expression for appending to the gRNA, default NGG
for SpCas9, change to TTTN for cpf1.}

\item{PAM.pattern}{Regular expression of PAM, default N[A|G]G$ for spCas9.
For cpf1, ^TTTN since it is a 5 prime PAM sequence}

\item{allowed.mismatch.PAM}{Maximum number of mismatches allowed in the
offtargets comparing to the PAM sequence. Default to 2 for NGG PAM}

\item{PAM.location}{PAM location relative to gRNA. For example, spCas9 PAM
is located on the 3 prime while cpf1 PAM is located on the 5 prime}

\item{outfile}{File path to temporarily store the search results}

\item{baseEditing}{Indicate whether to design gRNAs for base editing.
Default to FALSE If TRUE, please set baseEditing = TRUE, targetBase and
editingWidow accordingly.}

\item{targetBase}{Applicable only when baseEditing is set to TRUE. It is
used to indicate the target base for base editing systems, default to C for
converting C to T in the CBE system. Please change it to A if you intend to
use the ABE system.}

\item{editingWindow}{Applicable only when baseEditing is set to TRUE. It is
used to indicate the effective editing window to consider for the offtargets
search only, default to 4 to 8 which is for the original CBE system. Please
change it accordingly if the system you use have a different editing window,
or you would like to include offtargets with the target base in a larger
editing window.}
}
\value{
a data frame contains 

\itemize{
 \item **IsMismatch.posX** - whether this position X is mismatch or not, 
(1 means yes and 0 means not). X takes on values from 1 to gRNA.size, 
representing all positions in the guide RNA (gRNA).
 \item **strand** - Strand of the match (`+` for plus, `-` for minus).
 \item **chrom** - Chromosome where the off-target is located.
 \item **chromStart** - Start position of the off-target site.
 \item **chromEnd** - End position of the off-target site.
 \item **name** - gRNA name.
 \item **gRNAPlusPAM** - gRNA sequence with PAM sequence concatenated.
 \item **OffTargetSequence** - Genomic sequence of the off-target.
 \item **n.mismatch** - Number of mismatches between the off-target and the gRNA.
 \item **forViewInUCSC** - String for viewing in UCSC Genome Browser 
(e.g., `chr14:31665685-31665707`).
 \item **score** - Defaulted to 100, and will be updated in `getOfftargetScore()`.
}
}
\description{
Search for off targets for given gRNAs, sequence and maximum mismatches
}
\examples{

 all.gRNAs <- findgRNAs(inputFilePath =
       system.file("extdata", "inputseq.fa", package = "CRISPRseek"),
       pairOutputFile = "pairedgRNAs.xlsx",
       findPairedgRNAOnly = TRUE)
  hits <- searchHits(all.gRNAs[1], 
      seqs = DNAString(
           "TAATATTTTAAAATCGGTGACGTGGGCCCAAAACGAGTGCAGTTCCAAAGGCACCCACCTGTGGCAG"), 
      seqname = "myseq", max.mismatch = 10, outfile = "test_searchHits")
  colnames(hits)
  all.gRNAs <- findgRNAs(inputFilePath =
          DNAStringSet(
              "TAATATTTTAAAATCGGTGACGTGGGCCCAAAACGAGTGCAGTTCCAAAGGCACCCACCTGTGGCAG"),
          pairOutputFile = "pairedgRNAs.xlsx",
          findPairedgRNAOnly = FALSE,
          PAM = "TTTN", PAM.location = "5prime")
   hits <- searchHits(all.gRNAs[1], seqs = DNAString(
       "TAATATTTTAAAATCGGTGACGTGGGCCCAAAACGAGTGCAGTTCCAAAGGCACCCACCTGTGGCAG"), 
       seqname = "myseq", 
       max.mismatch = 0, 
       outfile = "test_searchHits", PAM.location = "5prime",
       PAM.pattern = "^T[A|T]NN", allowed.mismatch.PAM = 0, PAM = "TTTN")
   colnames(hits)
}
\seealso{
offTargetAnalysis
}
\author{
Lihua Julie Zhu
}
\keyword{misc}
