% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isPatternUnique.R
\name{isPatternUnique}
\alias{isPatternUnique}
\title{Output whether the input patterns occurs only once in the sequence}
\usage{
isPatternUnique(seq, patterns)
}
\arguments{
\item{seq}{flanking sequence of a gRNA}

\item{patterns}{patterns as DNAStringSet, such as a list of RE sites}
}
\value{
returns a character vectors containing the uniqueness of each
pattern/RE site
}
\description{
Input a sequence and a list of patterns and determine if the patterns occurs
only once in the sequence. Used for determining whether an RE site in gRNA
also occurs in the flanking region.
}
\examples{

    seq <- "TGGATTGTATAATCAGCATGGATTTGGAAC"
    patterns <- DNAStringSet(c("TGG", "TGGA", "TGGATA", "TTGGAAC", ""))
    isPatternUnique(seq, patterns)
}
\author{
Lihua Julie Zhu
}
\keyword{misc}
