% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtergRNAs.R
\name{filtergRNAs}
\alias{filtergRNAs}
\title{Filter gRNAs}
\usage{
filtergRNAs(
  all.gRNAs = NULL,
  pairOutputFile = NULL,
  findgRNAsWithREcutOnly = FALSE,
  REpatternFile = REpatternFile_default(),
  format = "fasta",
  minREpatternSize = 4,
  overlap.gRNA.positions = c(17, 18),
  overlap.allpos = TRUE
)
}
\arguments{
\item{all.gRNAs}{gRNAs as DNAStringSet, such as the output from findgRNAs}

\item{pairOutputFile}{File path with paired gRNAs}

\item{findgRNAsWithREcutOnly}{Indicate whether to find gRNAs overlap with
restriction enzyme recognition pattern}

\item{REpatternFile}{File path containing restriction enzyme cut patters}

\item{format}{Format of the REpatternFile, default as fasta}

\item{minREpatternSize}{Minimum restriction enzyme recognition pattern
length required for the enzyme pattern to be searched for, default 4}

\item{overlap.gRNA.positions}{The required overlap positions of gRNA and
restriction enzyme cut site, default 17 and 18}

\item{overlap.allpos}{Default TRUE, meaning that only gRNAs overlap with all
the positions are retained FALSE, meaning that gRNAs overlap with one or
both of the positions are retained}
}
\value{
\item{gRNAs.withRE }{gRNAs as DNAStringSet that passed the filter
criteria} \item{gRNAREcutDetails}{a data frame that contains a set of gRNAs
annotated with restriction enzyme cut details}
}
\description{
Filter gRNAs containing restriction enzyme cut site
}
\examples{

all.gRNAs <- findgRNAs(
  inputFilePath = system.file("extdata", "inputseq.fa",
  package = "CRISPRseek"),
  pairOutputFile = "testpairedgRNAs.xlsx",
  findPairedgRNAOnly = TRUE)

gRNAs.RE <- filtergRNAs(
  all.gRNAs = all.gRNAs,
  pairOutputFile = "testpairedgRNAs.xlsx",
  minREpatternSize = 6,
  REpatternFile = system.file("extdata", "NEBenzymes.fa", 
                              package = "CRISPRseek"), 
  overlap.allpos = TRUE)

gRNAs  <- gRNAs.RE$gRNAs.withRE
restriction.enzyme.cut.sites <- gRNAs.RE$gRNAREcutDetails

}
\seealso{
offTargetAnalysis
}
\author{
Lihua Julie Zhu
}
\keyword{misc}
