% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepCpf1.R
\name{deepCpf1}
\alias{deepCpf1}
\title{DeepCpf1 Algorithm for predicting CRISPR-Cpf1 gRNA Efficacy}
\usage{
deepCpf1(extendedSequence = NULL, chrom_acc = NULL)
}
\arguments{
\item{extendedSequence}{Sequences containing gRNA plus PAM plus flanking
sequences. Each sequence should be 34 bp long as specified by
http://deepcrispr.info/, i.e., 4bp before the 5' PAM, 4bp PAM, 20bp gRNA,
and 6bp after 3' of gRNA.}

\item{chrom_acc}{Optional binary variable indicating chromatin accessibility
information with 1 indicating accessible and 0 not accessible.}
}
\value{
a numeric vector with prediced CRISPR-Cpf1 gRNA efficacy
taking into account chromatin accessibility
information if accessibility information is provided
}
\description{
DeepCpf1 algorithm from https://doi.org/10.1038/nbt.4061, which
takes in 34 bp target sequences with/without chromatin
accessibility information and returns predicted CRISPR-Cpf1 gRNA efficacy
for each input sequence.
}
\details{
Having chromatin accessibility information will aid in the accuracy
of the scores, but one can still get accurate scoring with only the
34 bp target sequences.
}
\examples{
library(keras)
library(mltools)
library(dplyr)
library(data.table)

use_implementation("tensorflow")

extendedSequence <- c('GTTATTTGAGCAATGCCACTTAATAAACATGTAA',
 'TGACTTTGAATGGAGTCGTGAGCGCAAGAACGCT',
 'GTTATTTGAGCAATGCCACTTAATAAACATGTAA',
 'TGACTTTGAATGGAGTCGTGAGCGCAAGAACGCT')
chrom_acc <- c(0, 1, 0, 1)

if (interactive()) {
 deepCpf1(extendedSequence = extendedSequence, chrom_acc = chrom_acc)
}
}
\references{
Kim et al., Deep learning improves prediction of CRISPR–Cpf1
guide RNA activityNat Biotechnol 36, 239–241 (2018).
https://doi.org/10.1038/nbt.4061
}
\author{
Paul Scemama and Lihua Julie Zhu
}
