% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/km_overlay_plot_f.R
\name{km_overlay_plot_f}
\alias{km_overlay_plot_f}
\title{Overlay Kaplan-Meier Plot Function}
\arguments{
\item{Train_results}{A data frame containing the training samples' survival prediction results (obtained from RF risk prediction model).
The following columns are required:
\itemize{
\item \code{Sample_ID}: Unique identifier for the sample.
\item \code{Actual}: Actual TCGA ID (often the same as \code{Sample_ID}).
\item \code{Predicted_Risk_Group}: Predicted class label (e.g., \code{High_Risk} / \code{Low_Risk}).
\item \code{High_Risk_Prob}: Probability of being classified as High Risk.
\item \code{Low_Risk_Prob}: Probability of being classified as Low Risk.
\item \code{Prediction_Prob}: Maximum class probability (confidence in the prediction).
\item \code{OS_month}: Overall survival time in months.
\item \code{OS_event}: Event indicator (\code{1} = death, \code{0} = censored).
The data frame should have no duplicate \code{Sample_ID}s, and the \code{OS_month} column should be numeric while \code{OS_event} should be an integer.
}}

\item{Test_results}{A data frame containing the test samples' survival prediction results (obtained from RF risk prediction model).
The structure is similar to \code{Train_results}, with the following columns:
\itemize{
\item \code{Sample_ID}: Unique identifier for the sample.
\item \code{Actual}: Actual TCGA ID (often the same as \code{Sample_ID}).
\item \code{Predicted_Risk_Group}: Predicted class label (e.g., \code{High_Risk} / \code{Low_Risk}).
\item \code{High_Risk_Prob}: Probability of being classified as High Risk.
\item \code{Low_Risk_Prob}: Probability of being classified as Low Risk.
\item \code{Prediction_Prob}: Maximum class probability (confidence in the prediction).
\item \code{OS_month}: Overall survival time in months.
\item \code{OS_event}: Event indicator (\code{1} = death, \code{0} = censored).
The data frame should have no duplicate \code{Sample_ID}s, and the \code{OS_month} column should be numeric while \code{OS_event} should be an integer.
The \code{Sample_ID} of the \code{selected_sample} must be present in this data frame.
}}

\item{survcurve_te_data}{A data frame containing survival probability curves for test samples. It should include:
\itemize{
\item \code{time_point}: Time points for survival estimates.
\item \verb{<Sample_ID columns>}: Survival probabilities for each sample at each time point.
}}

\item{selected_sample}{The \code{Sample_ID} of the selected test sample for which the user wants to plot the overlayed Kaplan-Meier plot.
The \code{Sample_ID} should be present in the \code{Test_results} data frame.}

\item{font_size}{Numeric. Base font size for the plot text (axis labels, legend, and title).
Default is 12.}

\item{train_palette}{Character vector of colors for training group curves (e.g., c("red", "blue")).
Default is c("red", "blue").}

\item{test_line_col}{Character. Color of the overlaid test sample curve.
Default is "darkgreen".}

\item{test_line_type}{Character. Line type of the overlaid test sample curve (e.g., "dashed", "solid").
Default is "dashed".}
}
\value{
A \code{ggplot} object (from \code{ggsurvplot}) showing:
\itemize{
\item Kaplan-Meier survival curves for the training dataset, stratified by predicted risk group.
\item An overlaid survival curve for the selected test sample (in a dashed green line).
\item Annotations displaying the test sample's predicted risk group and prediction probability.
}
}
\description{
This function generates an overlayed Kaplan-Meier (KM) survival plot to visualize the survival curves
of training data stratified by predicted risk groups (e.g., High Risk vs Low Risk), along with the
survival curve of a selected test sample. It helps to visually assess how the test sample's predicted
survival aligns with the survival profiles of the training groups.
}
\examples{
# Example usage of the km_overlay_plot_f function

# Example Train_results data frame
# Load example data included in the package
data(Train_results, package = "CPSM")
data(Test_results, package = "CPSM")
data(survCurves_data, package = "CPSM")

# Generate Kaplan-Meier plot with overlay
KM_plot_results <- km_overlay_plot_f(
  Train_results = Train_results,
  Test_results = Test_results,
  survcurve_te_data = survCurves_data,
  selected_sample = "TCGA-TQ-A7RQ-04",
  font_size = 14,
  train_palette = c("purple", "orange"),
  test_curve_col = "black",
  test_curve_lty = "solid"
)

}
