% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COTAN-getters.R, R/COTAN-modifiers.R
\name{HandlingConditions}
\alias{HandlingConditions}
\alias{getAllConditions,COTAN-method}
\alias{getAllConditions}
\alias{getConditionName,COTAN-method}
\alias{getConditionName}
\alias{getCondition,COTAN-method}
\alias{getCondition}
\alias{normalizeNameAndLabels}
\alias{addCondition,COTAN-method}
\alias{addCondition}
\alias{dropCondition,COTAN-method}
\alias{dropCondition}
\title{Handling cells' \emph{conditions} and related functions}
\usage{
\S4method{getAllConditions}{COTAN}(objCOTAN, keepPrefix = FALSE)

\S4method{getConditionName}{COTAN}(objCOTAN, condName = "", keepPrefix = FALSE)

\S4method{getCondition}{COTAN}(objCOTAN, condName = "")

normalizeNameAndLabels(objCOTAN, name = "", labels = NULL, isCond = FALSE)

\S4method{addCondition}{COTAN}(objCOTAN, condName, conditions, override = FALSE)

\S4method{dropCondition}{COTAN}(objCOTAN, condName)
}
\arguments{
\item{objCOTAN}{a \code{COTAN} object}

\item{keepPrefix}{When \code{TRUE} returns the internal name of the
\emph{condition}: the one with the \code{COND_} prefix.}

\item{condName}{the name of an existing \emph{condition}.}

\item{name}{the name of the \emph{clusterization}/\emph{condition}. If not given the
last available \emph{clusterization} will be used, or no \emph{conditions}}

\item{labels}{a \emph{clusterization}/\emph{condition} to use. If given it will take
precedence on the one indicated by \code{name}}

\item{isCond}{a Boolean to indicate whether the function is dealing with
\emph{clusterizations} \code{\link{FALSE}} or \emph{conditions} \code{\link{TRUE}}}

\item{conditions}{a (factors) array of \emph{condition} \strong{labels}}

\item{override}{When \code{TRUE} silently allows overriding data for an existing
\emph{condition} name. Otherwise the default behavior will avoid potential
data losses}
}
\value{
\code{getAllConditions()} returns a vector of \emph{conditions} names,
usually without the \code{COND_} prefix

\code{getConditionName()} returns the normalized \emph{condition} name or
\code{NULL} if no \emph{conditions} are present

\code{getCondition()} returns a named \code{factor} with the \emph{condition}

\code{normalizeNameAndLabels()} returns a \code{list} with:
\itemize{
\item \code{"name"} the relevant name
\item \code{"labels"} the relevant \emph{clusterization}/\emph{condition}
}

\code{addCondition()} returns the updated \code{COTAN} object

\code{dropCondition()} returns the updated \code{COTAN} object
}
\description{
These functions manage the \emph{conditions}.

A \emph{condition} is a set of \strong{labels} that can be assigned to cells:
one \strong{label} per cell. This is especially useful in cases when the
\code{data-set} is the result of merging multiple experiments' raw data
}
\details{
\code{getAllConditions()} extracts the list of the \emph{conditions} defined
in the \code{COTAN} object.

\code{getConditionName()} normalizes the given \emph{condition} name or, if
none were given, returns the name of last available \emph{condition} in the
\code{COTAN} object. It can return the \emph{condition} \strong{internal name} if needed

\code{getCondition()} extracts the asked \emph{condition} from the \code{COTAN}
object

\code{normalizeNameAndLabels()} takes a pair of name/labels and
normalize them based on the available information in the \code{COTAN} object

\code{addCondition()} adds a \emph{condition} to the current \code{COTAN} object,
by adding a new column in the \code{metaCells} \code{data.frame}

\code{dropCondition()} drops a \emph{condition} from the current \code{COTAN}
object, by removing the corresponding column in the \code{metaCells}
\code{data.frame}
}
\examples{
data("test.dataset")
objCOTAN <- COTAN(raw = test.dataset)

cellLine <- rep(c("A", "B"), getNumCells(objCOTAN) / 2)
names(cellLine) <- getCells(objCOTAN)
objCOTAN <- addCondition(objCOTAN, condName = "Line", conditions = cellLine)

if (FALSE) {
  objCOTAN <- dropCondition(objCOTAN, "Genre")
}

conditionsNames <- getAllConditions(objCOTAN)

condName <- getConditionName(objCOTAN)

condition <- getCondition(objCOTAN, condName = condName)
isa(condition, "factor")

nameAndCond <- normalizeNameAndLabels(objCOTAN, name = condName,
                                      isCond = TRUE)
isa(nameAndCond[["labels"]], "factor")

}
