% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_fluo_NBE.R
\name{adjustFluo}
\alias{adjustFluo}
\title{adjustFluo}
\usage{
adjustFluo(data, transformation, BGmethod, maxMix, reference, prior.pi,
  flex.reps, flexmethod, image.type, savePlot, seed, dateIndex)
}
\arguments{
\item{data}{List. A list with the fluorescence signal information of both channels.}

\item{BGmethod}{Character string. The type of image background correction to be performed.
One of "normexp" or "subtract".}

\item{maxMix}{Integer. The maximum number of components to fit into the mixture of
regressions model. If maxMix=1 or if the the optimal number of the estimated components
is 1, the model reduces to the classical 2-way ANOVA.}

\item{reference}{Numeric vector. Specifies the runs to be used as baseline (iteratively).}

\item{prior.pi}{Float. The prior probability to accept a component.}

\item{flex.reps}{Integer. The iterations of the Expectation-Maximization algorithm to estimate
the flexmix model.}

\item{flexmethod}{Character string. A method to estimate the optimal number of flexmix
components. One of "BIC", "AIC", "ICL".}

\item{image.type}{Character string. A triplet of IDs to characterize the type of images under study.}

\item{savePlot}{Character string. The directory to store the plots or an option to print them on the screen.}

\item{seed}{Integer. An optional seed number for the Random Number Generator.}

\item{dateIndex}{Character string. a date index to be used in saving the output files.}

\item{transform}{Character string. The type of transformation to be performed. One
of "bc" (Box-Cox), "log", "log10" or "asinh".}
}
\value{
A list with the fluorescence signals, mixture components and flexmix model estimates
}
\description{
It performs the run effect correction and normalization of the raw fluorescence signals.
}
\keyword{internal}
