% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluo_NBE.R
\name{Fluo_adjustment}
\alias{Fluo_adjustment}
\title{Fluo_adjustment}
\usage{
Fluo_adjustment(data, BGmethod = "normexp", maxMix = 3,
  single.batch.analysis = 1, transformation = "log", prior.pi = 0.1,
  flex.reps = 50, flexmethod = "BIC", savePlot = getwd(),
  seed = NULL)
}
\arguments{
\item{data}{List. The output of createFluo().}

\item{BGmethod}{Character string. The type of image background correction to be performed.
One of "normexp" or "subtract". Default is "normexp".}

\item{maxMix}{Integer. The maximum number of components to fit into the mixture of
regressions model. If maxMix=1 or if the the optimal number of the estimated components
is 1, the model reduces to the classical 2-way ANOVA. Default is 3.}

\item{single.batch.analysis}{Integer. The baseline run against with the run effect
correction is perfomred. Default is 1. If 0, each run is used as baseline iteratively
and the final corrected data are obtained as the average of all corrections.}

\item{transformation}{Character string. One of bc (Box-Cox), log, log10, asinh transforms
applied to the data. Default is "log".}

\item{prior.pi}{Float. The prior probability to accept a component. Default is 0.1.}

\item{flex.reps}{Integer. The iterations of the Expectation-Maximization algorithm to estimate the flexmix
model. Default is 50.}

\item{flexmethod}{Character string. A method to estimate the optimal number of flexmix
components. One of "BIC", "AIC", "ICL". Default is "BIC".}

\item{savePlot}{Character string. Directory to store the plots. Its value can be an existing directory
or "screen" that prints the plot only on the screen or "OFF" that does not generate a plot (suggested
only during cross-validations). Default is the current working directory, getwd().}

\item{seed}{Integer. An optional seed number for the Random Number Generator. Note that this seed is a 'reference'
value of the actual seed used in sampling. CONFESS is using various random sampling methods. Each method's
actual seed is factor*seed. The factors vary across methods. Default is NULL.}
}
\value{
A list with the data description, the normalized and corrected estimates over all runs by averaging
  (Summarized_estimates) AND for a particular "reference" run (Batch_estimates). Analytically, the components
  are:
  General
    index: The sample indices.
    samples: the sample IDs.
    batch: a matrix of the run IDs. The first column contains the original run IDs. The second column is the converted
        original IDs into numeric values (to be used in the statistical modeling step of Fluo_adjustment()).
    Size: the estimated cell size.
    RGexprs: the foreground (columns 1 and 3) and background (columns 2 and 4) signals of each channel that
      have been estimated by spotEstimator() and filtered in LocationMatrix().
    exprs: the background corrected (only) signals of each channel. These data are fed into the flexmix model.
    image.type: the image type IDs as defined in readFiles().
    dateIndex: the date index used.
    single.batch.analysis: the reference run used for run effect correction with flexmix.
    BGmethod: the background correction method used.
    maxMix: the maxMix parameter used.
    prior.pi: the prior.pi parameter used.
    flex.reps: the flex.reps parameter used.
    flexmethod: the flexmethod parameter used.
    RNG: the seed that is used to generate the results.

  Summarized_estimates:
    corrected.exprs: the background and run effect corrected channel signals (by averaging the estimates of all runs).
    corrected.transformed.exprs: the background and run effect transformed corrected channel signals (by averaging the
      estimates of all runs). The transformation is defined in the transformation parameter (see above).
    allResults: the background and run effect corrected and transformed corrected channel signals (two different slots) for
      all runs.

  Batch_estimates: it contains the analytical results for each batch in different slots. Each slot includes:
    corrected.exprs: the background and run effect corrected channel signals (for a run).
    corrected.transformed.exprs: the background and run effect transformed corrected channel signals (for a run).
      The transformation is defined in the transformation parameter (see above).
    mixes.(image.type 1): the estimated components of the flexmix model for one channel.
    mixes.(image.type 2): the estimated components of the flexmix model for the other channel.
    Batch.(image.type 1).est: the run effects of one channel. It contains the model estimates and significance P-values/FDRs.
      "Comp" corresponds to the factor of flexmix components (mixes) and "Batch" to the factor of runs.
    Batch.(image.type 2).est: the run effects of the other channel. It contains the model estimates and significance P-values/FDRs.
      "Comp" corresponds to the factor of flexmix components (mixes) and "Batch" to the factor of runs.
    fitted.values: the fitted values of the flexmix model for each channel.
    transformation: the transformation applied on the fluorescence signals (it stores the value of transformation parameter).
    model.residuals: the flexmix residuals for each channel.
    model.standardized.residuals: the flexmix standardized residuals for each channel.
    residual.statistics: the result of various normality tests for the residuals.
    lpar: the lambda parameter of the Box-Cox transformation (if used).
    design.(image.type 1): the design matrix of one channel.
    design.(image.type 2): the design matrix of the other channel.
    reference: the run that has been used as reference.
    (image.type 1).contrasts: the contrasts matrix for the differences across flexmix components and runs for one channel (only for
      the reference batch if any).
    (image.type 2).contrasts: the contrasts matrix for the differences across flexmix components and runs for the other channel (only for
      the reference batch if any).
}
\description{
A summary of the signal adjustment algorithms into a single function. It corrects the
  run effect (if any) and performs background adjustment for appropriately transformed data.
}
\examples{
step2 <- Fluo_adjustment(data=step1,flex.reps = 5,single.batch.analysis=5,savePlot="OFF")
}
