% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pheno_assoc.R
\name{cnvGWAS}
\alias{cnvGWAS}
\title{Run the CNV-GWAS}
\usage{
cnvGWAS(
  phen.info,
  n.cor = 1,
  min.sim = 0.95,
  freq.cn = 0.01,
  snp.matrix = FALSE,
  method.m.test = "fdr",
  lo.phe = 1,
  chr.code.name = NULL,
  genotype.nodes = "CNVGenotype",
  coding.translate = "all",
  path.files = NULL,
  list.of.files = NULL,
  produce.gds = TRUE,
  run.lrr = FALSE,
  assign.probe = "min.pvalue",
  correct.inflation = FALSE,
  both.up.down = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{phen.info}{Returned by \code{\link{setupCnvGWAS}}}

\item{n.cor}{Number of cores to be used}

\item{min.sim}{Minimum CNV genotype distribution similarity among subsequent
probes. Default is 0.95 (i.e. 95\%)}

\item{freq.cn}{Minimum CNV frequency where 1 (i.e. 100\%), or all samples 
deviating from diploid state. Default 0.01 (i.e. 1\%)}

\item{snp.matrix}{Only FALSE implemented - If TRUE B allele frequencies (BAF)
would be used to reconstruct CNV-SNP genotypes}

\item{method.m.test}{Correction for multiple tests to be used. FDR is default, 
see \code{\link{p.adjust}} for other methods.}

\item{lo.phe}{The phenotype to be analyzed in the PhenInfo$phenotypesSam data-frame}

\item{chr.code.name}{A data-frame with the integer name in the first column 
and the original name for each chromosome}

\item{genotype.nodes}{Expression data type. Nodes with CNV genotypes to be 
produced in the gds file.}

\item{coding.translate}{For 'CNVgenotypeSNPlike'. If NULL or unrecognized 
string use only biallelic CNVs. If 'all' code multiallelic CNVs as 0 
for loss; 1 for 2n and 2 for gain.}

\item{path.files}{Folder containing the input CNV files used for the CNV 
calling (i.e. one text file with 5 collumns for each sample). Columns should 
contain (i) probe name, (ii) Chromosome, (iii) Position, (iv) LRR, and (v) BAF.}

\item{list.of.files}{Data-frame with two columns where the (i) is the file 
name with signals and (ii) is the correspondent name of the sample in the gds file}

\item{produce.gds}{logical. If TRUE produce a new gds, if FALSE use gds previously created}

\item{run.lrr}{If TRUE use LRR values instead absolute copy numbers in the association}

\item{assign.probe}{\sQuote{min.pvalue} or \sQuote{high.freq} to represent the CNV segment}

\item{correct.inflation}{logical. Estimate lambda from raw p-values and correct for genomic inflation.
Use with argument \code{method.m.test} to generate strict p-values.}

\item{both.up.down}{Check for CNV genotype similarity in both directions. 
Default is FALSE (i.e. only downstream)}

\item{verbose}{Show progress in the analysis}
}
\value{
The CNV segments and the representative probes and their respective p-value
}
\description{
Wraps all the necessary functions to run a CNV-GWAS using the output of 
\code{\link{setupCnvGWAS}} function.
 
(i) Produces the GDS file containing the genotype information  (if produce.gds == TRUE),
(ii) Produces the requested inputs for a PLINK analysis, 
(iii) run a CNV-GWAS analysis using a linear model (i.e. \code{\link{lm}} function), and 
(iv) export a QQ-plot displaying the adjusted p-values. 
In this release only the p-value for the copy number is available  (i.e. 'P(CNP)').
}
\examples{

# Load phenotype-CNV information
data.dir <- system.file("extdata", package="CNVRanger")

phen.loc <- file.path(data.dir, "Pheno.txt")
cnv.out.loc <- file.path(data.dir, "CNVOut.txt")
map.loc <- file.path(data.dir, "MapPenn.txt")

phen.info <- setupCnvGWAS('Example', phen.loc, cnv.out.loc, map.loc)

# Define chr correspondence to numeric, if necessary
df <- '16 1A
25 4A
29 25LG1
30 25LG2
31 LGE22'

chr.code.name <- read.table(text=df, header=FALSE)
segs.pvalue.gr <- cnvGWAS(phen.info, chr.code.name=chr.code.name)
 
}
\references{
da Silva et al. (2016) Genome-wide detection of CNVs and their 
association with meat tenderness in Nelore cattle. PLoS One, 11(6):e0157711.
}
\seealso{
\code{link{setupCnvGWAS}} to setup files needed for the CNV-GWAS.
}
\author{
Vinicius Henrique da Silva
}
