% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatasetGenerator.R
\name{set_generator_edges}
\alias{set_generator_edges}
\title{Add edge weights to a generator}
\usage{
set_generator_edges(generator, f_t_w_list, by = "labels")
}
\arguments{
\item{generator}{a generator}

\item{f_t_w_list}{a list of triplets (from, to, list), the triplets must not 
be nested in the list. For example list("A","B",0.3, "B", "C", 0.2) is a valid
input.}

\item{by}{"labels" or "samples" to use gene labels or sample labels as references for
edge identifiers.}
}
\value{
the generator with the modified edges (invalid edges are ignored)
}
\description{
Add edge weights to a generator
}
\examples{
require(dplyr)

example_dataset() \%>\%
 make_generator_stub() \%>\% 
 set_generator_edges(
   list(
    "D", "A, D", 1 , 
    "A", "A, D", 1 , 
    "A, D", "A, C, D", 1 , 
    "A, D", "A, B, D", 1 , 
    "Clonal", "D", 1 , 
    "Clonal", "A", 1 , 
    "D", "D", 1 , 
    "A", "A", 1 , 
    "A, D", "A, D", 1 , 
    "A, C, D", "A, C, D", 1 , 
    "A, B, D", "A, B, D", 1 , 
    "Clonal", "Clonal", 1 
  ))
   
}
