% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{select_samples_on_mutations}
\alias{select_samples_on_mutations}
\title{Filter dataset by samples' mutation count}
\usage{
select_samples_on_mutations(mutmatrix, n, desc = TRUE)
}
\arguments{
\item{mutmatrix}{input dataset (mutational matrix) to be reduced}

\item{n}{number of samples to be kept}

\item{desc}{T: select the n least mutated samples,
F: select the n most mutated samples}
}
\value{
the modified dataset (mutational matrix)
}
\description{
Dataset filtering on samples, based on their mutation count
}
\examples{
require(dplyr)
# keep information on the 5 most mutated samples
select_samples_on_mutations(example_dataset(), 5)
# keep information on the 5 least mutated samples
select_samples_on_mutations(example_dataset(), 5, desc = FALSE)
# combine selections
select_samples_on_mutations(example_dataset() , 5, desc = FALSE) \%>\%
    select_genes_on_mutations(5)

}
