% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_profile}
\alias{plot_profile}
\alias{plot_profile,CEMiTool-method}
\title{Expression profile visualization}
\usage{
plot_profile(cem, ...)

\S4method{plot_profile}{CEMiTool}(cem, order_by_class = TRUE, center_func = "mean")
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}.}

\item{...}{Optional parameters.}

\item{order_by_class}{Logical. Only used if a sample
annotation file is present. Whether or not to order by the
class column in the sample annotation file (as defined by the
class_column slot in \code{cem}).}

\item{center_func}{Character string indicating the centrality measure to show in
the plot. Either 'mean' (the default) or 'median'.}
}
\value{
Object of class \code{CEMiTool} with profile plots
}
\description{
Creates a plot with module gene expression profiles along samples
}
\examples{
# Get example CEMiTool object
data(cem)
# Plot module gene expression profiles
cem <- plot_profile(cem)
# Check resulting plot
show_plot(cem, "profile")

}
