% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Richness.R
\name{hanabiPlot}
\alias{hanabiPlot}
\title{hanabiPlot}
\usage{
hanabiPlot(x, group, col = NULL, legend.pos = "topleft", pch = 1, ...)
}
\arguments{
\item{x}{A hanabi object.}

\item{group}{A character vector or a factor grouping the samples.}

\item{col}{A character vector colors (at most one per group).}

\item{legend.pos}{Position of the legend, passed to the \code{legend} function.}

\item{pch}{Plot character at the tip of the lines and in the legend.}

\item{...}{Further arguments to be passed to the \code{plot.hanabi} function.}
}
\description{
Plot feature discovery curves
}
\details{
Plots the number of features (genes, transcripts, ...) detected for a
given number of counts (reads, unique molecules, ...).  Each library is
sub-sampled by rarefaction at various sample sizes, picked to provide
enough points so that the curves look smooth.  The final point is plotted
as an open circle, hence the name "hanabi", which means fireworks in
Japanese.

The rarefactions take time to do, so this step is done by a separate
function, so that the result is easily cached.
}
\examples{
h <- hanabi(CTSStagCountDF(exampleCAGEexp))
hanabiPlot(h, group = 1:5)
hanabiPlot(hanabi(CTSStagCountDF(exampleCAGEexp), n = 20, step = 0.8, from = 25000), group = 1:5)
hanabiPlot(hanabi(CTSStagCountDF(exampleCAGEexp), n = 10, step = 0.98), group = 1:5)
hanabiPlot(h, group=c("A", "A", "B", "C", "B"), col=c("red", "green", "blue"))
hanabiPlot(h, group = 1:5, pch=1:5, col="purple")

}
\seealso{
Other CAGEr richness functions: 
\code{\link{hanabi}},
\code{\link{plot.hanabi}()}

Other CAGEr richness functions: 
\code{\link{hanabi}},
\code{\link{plot.hanabi}()}

Other CAGEr plot functions: 
\code{\link{TSSlogo}()},
\code{\link{plotAnnot}()},
\code{\link{plotCorrelation}()},
\code{\link{plotExpressionProfiles}()},
\code{\link{plotInterquantileWidth}()},
\code{\link{plotReverseCumulatives}()}
}
\author{
Charles Plessy
}
\concept{CAGEr plot functions}
\concept{CAGEr richness functions}
