% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalizationFunctions.R
\name{.powerLaw}
\alias{.powerLaw}
\title{.powerLaw}
\usage{
.powerLaw(tag.counts, fitInRange = c(10, 1000), alpha = 1.25, T = 10^6)
}
\arguments{
\item{tag.counts}{Numerical values whose reverse cumulative distribution will be fitted
to power-law (e.g. tag count or signal for regions, peaks, etc.)}

\item{fitInRange}{Range in which the fitting is done (values outside of this range will
not be considered for fitting)}

\item{alpha}{Slope of the referent power-law distribution (the actual slope has negative
sign and will be -1*alpha)}

\item{T}{total number of tags (signal) in the referent power-law distribution.}
}
\value{
Normalized values (vector of the same length as input values); i.e. what would
be the value of input values in the referent distribution.  Ouptut objects are numeric,
possibly \code{Rle}-encoded or wrapped in \code{data.frames} or \code{DataFrames}
according to the input.
}
\description{
Private funtion for normalizing CAGE tag count to a referent power-law distribution.
}
\details{
S4 Methods are provided for integer vectors, Rle objects, data.frame objects
and DataFrame objects, so that the most complex objects can be deconstructed
in simpler parts, normalized and reconstructed.
}
\references{
Balwierz, P. J., Carninci, P., Daub, C. O., Kawai, J., Hayashizaki,
Y., Van Belle, W., Beisel, C., et al. (2009). Methods for analyzing deep sequencing
expression data: constructing the human and mouse promoterome with deepCAGE data.
Genome Biology, 10(7), R79.
}
