% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportMethods.R
\name{plotExpressionProfiles}
\alias{plotExpressionProfiles}
\alias{plotExpressionProfiles,CAGEexp-method}
\title{Plot CAGE expression profiles}
\usage{
plotExpressionProfiles(object, what)

\S4method{plotExpressionProfiles}{CAGEexp}(object, what = c("CTSS", "consensusClusters"))
}
\arguments{
\item{object}{A \code{\link{CAGEr}} object.}

\item{what}{\code{CTSS} or \code{consensusClusters}.}
}
\description{
Beanplot of distribution of normalized expression across CAGE
experiments for individual \emph{expression classes}, colored and labeled
according to the information set when expression clustering was performed.
}
\details{
The beanplots are shown in one labeled box per \emph{expression class}.
Each beanplot represents one CAGE experiment.  The vertical axis represents
scaled normalized expression.  The color of each class is determined by the
labels returned by expression clustering.
}
\examples{
plotExpressionProfiles(exampleCAGEexp, what = "CTSS")
exampleCAGEexp |> plotExpressionProfiles("consensusClusters")

}
\seealso{
Other CAGEr plot functions: 
\code{\link{TSSlogo}()},
\code{\link{hanabiPlot}()},
\code{\link{plotAnnot}()},
\code{\link{plotCorrelation}()},
\code{\link{plotInterquantileWidth}()},
\code{\link{plotReverseCumulatives}()}

Other CAGEr expression clustering functions: 
\code{\link{expressionClasses}()},
\code{\link{getExpressionProfiles}()}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{CAGEr expression clustering functions}
\concept{CAGEr plot functions}
